/*
 * QrfeEM4325Tag.h
 *
 *  Created on: 08.10.2013
 *      Author: stefan.detter
 */

#ifndef QRFEEM4325TAG_H_
#define QRFEEM4325TAG_H_

#include "../QrfeGen2Tag.h"
#include "../../QrfeGen2AdvancedManipulatorInterface.h"

class QrfeEM4325Tag : public QrfeGen2Tag
{
public:
    QrfeEM4325Tag(QString tagId, QrfeGen2AdvancedManipulatorInterface* reader, QObject* parent = 0);
	virtual ~QrfeEM4325Tag();

	typedef struct{
		bool lowBatteryAlarm;
		bool auxAlarm;
		bool overTempAlarm;
		bool underTempAlarm;
		bool p3Input;
		bool monitorEnabled;
		bool simpleSensor;
		double temperature;
		ushort abortedTempMeasurements;
		ushort underTempCount;
		ushort overTempCount;
	} SENSOR_DATA;

	QrfeGlobal::TMIResult getSensorData ( const QByteArray& passwd, bool sendUID, bool getNewSample, QByteArray& uid, SENSOR_DATA& sensorData, uint& utcTimeStamp );

	QrfeGlobal::TMIResult getSensorData ( const QByteArray& handle, const QByteArray& passwd, bool sendUID, bool getNewSample, QByteArray& uid, SENSOR_DATA& sensorData, uint& utcTimeStamp );
};

#endif /* QRFEEM4325TAG_H_ */
